import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.accountingSchemaId) {
    newObjValue = {...newObjValue, 
      C_AcctSchema_ID: {
        id: body.accountingSchemaId,
        tableName: 'C_AcctSchema'
      }
    }
  }
  if(body.revenueAccountId) {
    newObjValue = {...newObjValue, 
      P_Revenue_Acct: {
        id: body.revenueAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.expenseAccountId) {
    newObjValue = {...newObjValue, 
      P_Expense_Acct: {
        id: body.expenseAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.assetAccountId) {
    newObjValue = {...newObjValue, 
      P_Asset_Acct: {
        id: body.assetAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.cogsAccountId) {
    newObjValue = {...newObjValue, 
      P_COGS_Acct: {
        id: body.cogsAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.purchasePriceVarianceAccountId) {
    newObjValue = {...newObjValue, 
      P_PurchasePriceVariance_Acct: {
        id: body.purchasePriceVarianceAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.invoicePriceVarianceAccountId) {
    newObjValue = {...newObjValue, 
      P_InvoicePriceVariance_Acct: {
        id: body.invoicePriceVarianceAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.tradeDiscountReceivedAccountId) {
    newObjValue = {...newObjValue, 
      P_TradeDiscountRec_Acct: {
        id: body.tradeDiscountReceivedAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.tradeDiscountGrantAccountId) {
    newObjValue = {...newObjValue, 
      P_TradeDiscountGrant_Acct: {
        id: body.tradeDiscountGrantAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.inventoryClearingAccountId) {
    newObjValue = {...newObjValue, 
      P_InventoryClearing_Acct: {
        id: body.inventoryClearingAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.costAdjustmentAccountId) {
    newObjValue = {...newObjValue, 
      P_CostAdjustment_Acct: {
        id: body.costAdjustmentAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.rateVarianceAccountId) {
    newObjValue = {...newObjValue, 
      P_RateVariance_Acct: {
        id: body.rateVarianceAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.averageCostVarianceAccountId) {
    newObjValue = {...newObjValue, 
      P_AverageCostVariance_Acct: {
        id: body.averageCostVarianceAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.landedCostClearingAccountId) {
    newObjValue = {...newObjValue, 
      P_LandedCostClearing_Acct: {
        id: body.landedCostClearingAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_product_acct/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      ...newObjValue,
      tableName: 'm_product_acct'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    if(err.status >= 500 || err.statusCode >= 500) {
      data = {
        status: err.status || err.statusCode,
        message: err.detail || err.details || err.message || err.statusMessage
      }
    } else {
    try {
        let authToken: any = await refreshTokenHelper(event)
        data = await handleFunc(event, authToken)
      } catch(error: any) {
        data = {
          status: error.status || error.statusCode || 500,
          message: error.detail || error.details || error.message || error.statusMessage
        }
      }
    }
  }

  return data
})